
function [error] = optimiseFun_FR(parms, FR, medSWA, N, A)

% Upack parms
alpha = parms(1);
beta = parms(2);
S0 = parms(3);
FRthr = parms(4);
Smax = parms(5);
Smin = parms(6);

% S model
Tmax = 43200;
S = zeros(1,Tmax);
S(1) = S0;
for t=2:Tmax    
	if FR(t) > FRthr
    	dSdt = alpha*(Smax - S(t-1))*(FR(t) - FRthr); 
    else 
    	dSdt = beta*(Smin - S(t-1))*(FRthr - FR(t));
    end
    S(t) = S(t-1) + dSdt;
end

% Error
[medProcS, durN] = medianBoutNREM(S, N, A);
durN(durN<=15) =[];
w = durN/sum(durN);
error = sum(abs(medSWA(:,2) - medProcS(:,2)) .*w');

end 